definition module _SystemEnum

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.3
//	Copyright 1998 University of Nijmegen
// ****************************************************************************************

/*
	This module must be imported if dotdot expressions are used

		[from .. ]			-> _from from
		[from .. to]		-> _from_to from to
		[from, then .. ]	-> _from_then from then
		[from, then .. to]	-> _from_then_to from then to
*/
	
from StdClass import Enum, IncDec, Ord
from StdBool import not 

import StdInt
export IncDec Int
export Ord Int
export Enum Int

import StdChar
export IncDec Char
export Ord Char
export Enum Char

_from			::  a		-> .[a] | IncDec , Ord a
_from_to		:: !a !a	-> .[a] | Enum a
_from_then		::  a  a	-> .[a] | Enum a
_from_then_to	:: !a !a !a	-> .[a] | Enum a

_lteq a b	:== not (b < a)
_minus a b	:== max (-1) (toInt (a - b))
